/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui.views;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.rooms.RoomType;
import technology.rocketjump.undermount.ui.views.DefaultGuiView;
import technology.rocketjump.undermount.ui.views.EntitySelectedGuiView;
import technology.rocketjump.undermount.ui.views.FurnitureSelectionGuiView;
import technology.rocketjump.undermount.ui.views.GuiView;
import technology.rocketjump.undermount.ui.views.GuiViewName;
import technology.rocketjump.undermount.ui.views.OrderSelectionGuiView;
import technology.rocketjump.undermount.ui.views.RoomSelectionGuiView;
import technology.rocketjump.undermount.ui.views.RoomSizingGuiView;

@Singleton
public class GuiViewRepository
implements Telegraph {
    private final MessageDispatcher messageDispatcher;
    private Map<GuiViewName, GuiView> byName = new EnumMap<GuiViewName, GuiView>(GuiViewName.class);

    @Inject
    public GuiViewRepository(DefaultGuiView defaultGuiView, OrderSelectionGuiView orderSelectionGuiView, RoomSelectionGuiView roomSelectionGuiView, RoomSizingGuiView roomSizingGuiView, FurnitureSelectionGuiView furnitureSelectionGuiView, EntitySelectedGuiView entitySelectedGuiView, MessageDispatcher messageDispatcher) {
        this(Arrays.asList(defaultGuiView, orderSelectionGuiView, roomSelectionGuiView, roomSizingGuiView, furnitureSelectionGuiView, entitySelectedGuiView), messageDispatcher);
    }

    public GuiViewRepository(List<GuiView> views, MessageDispatcher messageDispatcher) {
        views.forEach(this::add);
        this.messageDispatcher = messageDispatcher;
        messageDispatcher.addListener(this, 256);
        messageDispatcher.addListener(this, 291);
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 256: {
                RoomType selectedRoomType = (RoomType)msg.extraInfo;
                FurnitureSelectionGuiView furnitureSelectionView = (FurnitureSelectionGuiView)this.byName.get((Object)GuiViewName.ROOM_FURNITURE_SELECTION);
                furnitureSelectionView.setCurrentRoomType(selectedRoomType);
                RoomSizingGuiView guiView = (RoomSizingGuiView)this.byName.get((Object)GuiViewName.ROOM_SIZING);
                guiView.setCurrentRoomType(selectedRoomType);
                return true;
            }
            case 291: {
                for (GuiView guiView : this.byName.values()) {
                    guiView.onLanguageUpdated();
                }
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }

    private void add(GuiView view) {
        if (this.byName.containsKey((Object)view.getName())) {
            throw new RuntimeException("Duplicate GuiView name " + view.getName().name() + " attempting to be added to " + this.getClass().getSimpleName());
        }
        this.byName.put(view.getName(), view);
    }

    public GuiView getByName(GuiViewName name) {
        return this.byName.get((Object)name);
    }
}

